package ru.yandex.webmaster3.api.addurl.action;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.addurl.data.RecrawlStatusEnum;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.addurl.UrlForRecrawl;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.addurl.AddUrlRequestsService;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;

/**
 * @author avhaliullin
 */
@Description("Проверить статус заявки")
@Category("addurl")
@Component
public class GetRecrawlRequestInfoAction extends AbstractApiAction<GetRecrawlRequestInfoRequest, GetRecrawlRequestInfoResponse> {
    private AddUrlRequestsService addUrlRequestsService;

    public GetRecrawlRequestInfoAction() {
        super(Permission.COMMON);
    }

    @Override
    public GetRecrawlRequestInfoResponse process(GetRecrawlRequestInfoRequest request) {
        WebmasterHostId hostId = request.getLocator().getHostId();
        UUID taskId = request.getLocator().getTaskId();

        UrlForRecrawl urlForRecrawl = addUrlRequestsService.get(hostId, taskId);
        if (urlForRecrawl == null) {
            return new GetRecrawlRequestInfoResponse.TaskNotFoundResponse();
        }

        URL fullUrl;
        try {
            fullUrl = new URL(urlForRecrawl.getFullUrl());
        } catch (MalformedURLException e) {
            // should never happen
            throw new WebmasterException("Unable to construct URL",
                   new WebmasterErrorResponse.InternalUnknownErrorResponse(this.getClass(),
                            "Unable to construct URL"), e);
        }

        GetRecrawlRequestInfoResponse.NormalResponse response = new GetRecrawlRequestInfoResponse.NormalResponse(
                taskId, fullUrl, urlForRecrawl.getAddDate(), RecrawlStatusEnum.fromRecrawlState(urlForRecrawl.getState()));

        return response;
    }

    @Required
    public void setAddUrlRequestsService(AddUrlRequestsService addUrlRequestsService) {
        this.addUrlRequestsService = addUrlRequestsService;
    }
}
