package ru.yandex.webmaster3.api.addurl.action;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.addurl.data.RecrawlStatusEnum;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;

import java.net.URL;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public interface GetRecrawlRequestInfoResponse extends ApiGetResponse {
    class NormalResponse extends Success200 implements GetRecrawlRequestInfoResponse {
        private final UUID taskId;
        private final URL url;
        private final DateTime addedTime;
        private final RecrawlStatusEnum state;

        public NormalResponse(UUID taskId, URL url, DateTime addedTime, RecrawlStatusEnum state) {
            this.taskId = taskId;
            this.url = url;
            this.addedTime = addedTime;
            this.state = state;
        }

        @Description("идентификатор задачи на обход")
        public UUID getTaskId() {
            return taskId;
        }

        @Description("URL страницы, добавленной в переобход")
        public URL getUrl() {
            return url;
        }

        @Description("дата создания заявки на переобход")
        public DateTime getAddedTime() {
            return addedTime;
        }

        @Description("статус заявки на переобход")
        public RecrawlStatusEnum getState() {
            return state;
        }
    }
    enum Errors implements ApiErrorCode{
        TASK_NOT_FOUND,
    }

    @Description("Не найдена задача с таким id")
    class TaskNotFoundResponse extends NotFound404<Errors> implements GetRecrawlRequestInfoResponse {
        public TaskNotFoundResponse() {
            super(Errors.TASK_NOT_FOUND, "Task not found");
        }
    }
}
