package ru.yandex.webmaster3.api.addurl.action;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.api.addurl.RecrawlQueueLocator;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiDateRangeRequest;
import ru.yandex.webmaster3.api.http.common.request.traits.ApiPaginationRequest;

/**
 * @author avhaliullin
 */
public class ListRecrawlRequestsRequest extends AbstractApiUserVerifiedHostRequest<RecrawlQueueLocator>
        implements ApiPaginationRequest, ApiDateRangeRequest {

    private DateTime dateFrom = null;
    private DateTime dateTo = null;
    private int offset = 0;
    private int limit = 0;

    @Override
    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public DateTime getDateFrom() {
        return dateFrom;
    }

    @Override
    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo;
    }

    @Override
    public DateTime getDateTo() {
        return dateTo;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return offset;
    }

    @Override
    @MaxValue(100)
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public int getLimit() {
        return limit;
    }
}
