package ru.yandex.webmaster3.api.addurl.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.addurl.data.RecrawlRequestInfo;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ListRecrawlRequestsResponse extends ApiGetResponse.Success200 {
    private final int count;
    private final List<RecrawlRequestInfo> tasks;

    public ListRecrawlRequestsResponse(List<RecrawlRequestInfo> tasks, int count) {
        this.tasks = tasks;
        this.count = count;
    }

    @Description("общее количество заявок")
    public int getCount() {
        return count;
    }

    @Description("список заявок")
    public List<RecrawlRequestInfo> getTasks() {
        return tasks;
    }
}
