package ru.yandex.webmaster3.api.addurl.data;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.addurl.UrlForRecrawl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class RecrawlRequestInfo {
    private final UUID taskId;
    private final URL url;
    private final DateTime addedTime;
    private final RecrawlStatusEnum state;

    private RecrawlRequestInfo(UUID taskId, URL url, DateTime addedTime, RecrawlStatusEnum state) {
        this.taskId = taskId;
        this.url = url;
        this.addedTime = addedTime;
        this.state = state;
    }

    @Description("идентификатор задачи на обход")
    public UUID getTaskId() {
        return taskId;
    }

    @Description("URL страницы, добавленной в переобход")
    public URL getUrl() {
        return url;
    }

    @Description("дата создания заявки на переобход")
    public DateTime getAddedTime() {
        return addedTime;
    }

    @Description("статус заявки на переобход")
    public RecrawlStatusEnum getState() {
        return state;
    }

    @Nullable
    public static RecrawlRequestInfo fromUrlForRecrawl(UrlForRecrawl urlForRecrawl) {
        URL fullUrl;
        try {
            fullUrl = new URL(urlForRecrawl.getFullUrl());
        } catch (MalformedURLException e) {
            // should never happen
            return null;
        }

        return new RecrawlRequestInfo(
                urlForRecrawl.getUrlId(),
                fullUrl,
                urlForRecrawl.getAddDate(),
                RecrawlStatusEnum.fromRecrawlState(urlForRecrawl.getState()));
    }
}
