package ru.yandex.webmaster3.api.addurl.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.addurl.RecrawlState;

/**
 * @author avhaliullin
 */
public enum RecrawlStatusEnum {
    @Description("Задача в процессе")
    IN_PROGRESS,
    @Description("URL успешно переобойден")
    DONE,
    @Description("Не удалось обойти страницу")
    FAILED,
    ;

    public static RecrawlStatusEnum fromRecrawlState(RecrawlState coreState) {
        switch (coreState) {
            case NEW:
            case IN_PROGRESS:
                return IN_PROGRESS;

            case PROCESSED:
                return DONE;

            case UNKNOWN:
            case STALE:
                return FAILED;

            default:
                throw new RuntimeException("Unexpected core state: " + coreState);
        }
    }
}
