package ru.yandex.webmaster3.api.diagnostics.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;
import ru.yandex.webmaster3.storage.checklist.data.AbstractProblemInfo;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public class ApiProblemInfo {
    private final SiteProblemSeverityEnum severity;
    private final ApiSiteProblemState state;
    private final Optional<DateTime> lastStateUpdate;

    public ApiProblemInfo(SiteProblemSeverityEnum severity, ApiSiteProblemState state, Optional<DateTime> lastStateUpdate) {
        this.severity = severity;
        this.state = state;
        this.lastStateUpdate = lastStateUpdate;
    }

    @Description("важность проблемы")
    public SiteProblemSeverityEnum getSeverity() {
        return severity;
    }

    @Description("состояние проблемы")
    public ApiSiteProblemState getState() {
        return state;
    }

    @Description("дата последнего изменения статуса проблемы. Отсутствует, если статус не менялся никогда")
    public Optional<DateTime> getLastStateUpdate() {
        return lastStateUpdate;
    }

    public static ApiProblemInfo fromCoreProblemInfo(AbstractProblemInfo problemInfo, boolean isMainMirror) {
        ApiSiteProblemState state = ApiSiteProblemState.fromCoreState(problemInfo.getUserVisibleState(isMainMirror));
        return new ApiProblemInfo(problemInfo.getProblemType().getSeverity(),
                state, Optional.ofNullable(problemInfo.getLastUpdate()));
    }
}
