package ru.yandex.webmaster3.api.diagnostics.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemState;

/**
 * @author avhaliullin
 */
public enum ApiSiteProblemState {
    @Description("на сайте присутствует проблема")
    PRESENT,
    @Description("проблема отсутствует")
    ABSENT,
    @Description("состояние проблемы для сайта не определено")
    UNDEFINED,
    @Description("проблема не применима к данному сайту")
    NOT_APPLICABLE,
    ;

    public static ApiSiteProblemState fromCoreState(SiteProblemState coreState) {
        switch (coreState) {
            case PRESENT:
                return PRESENT;
            case ABSENT:
                return ABSENT;
            case UNDEFINED:
                return UNDEFINED;
            case NOT_APPLICABLE:
                return NOT_APPLICABLE;
            default:
                throw new RuntimeException("Unexpected core problem state: " + coreState);
        }
    }
}
