package ru.yandex.webmaster3.api.diagnostics.data;

import java.util.EnumMap;
import java.util.Map;

import org.jetbrains.annotations.Nullable;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;

/**
 * @author avhaliullin
 */
public enum ApiSiteProblemTypeEnum {
    @Description("для сайта не указаны файлы sitemap")
    NO_SITEMAPS(SiteProblemTypeEnum.SITEMAP_NOT_SET),
    @Description("в файлах sitemap сайта присутствуют ошибки")
    ERRORS_IN_SITEMAPS(SiteProblemTypeEnum.ERRORS_IN_SITEMAPS),
    @Description("для сайта не указаны регионы")
    NO_REGIONS(SiteProblemTypeEnum.NO_REGIONS),
    @Description("сайт не зарегистрирован в яндекс.справочнике")
    NOT_IN_SPRAV(SiteProblemTypeEnum.NO_DICTIONARY_REGIONS),
    @Description("обход сайта запрещен в файле robots.txt")
    DISALLOWED_IN_ROBOTS(SiteProblemTypeEnum.DISALLOWED_IN_ROBOTS),
    @Description("не удается получить содержимое сайта из-за ошибки DNS")
    DNS_ERROR(SiteProblemTypeEnum.DNS_ERROR),
    @Description("см. https://yandex.ru/support/webmaster/recommendations/frequent-mistakes.html 'Soft 404'")
    SOFT_404(SiteProblemTypeEnum.NO_404_ERRORS),
    @Description("в файле robots.txt обнаружены ошибки")
    ERROR_IN_ROBOTS_TXT(SiteProblemTypeEnum.ROBOTS_TXT_ERROR),
    @Description("главная страница сайта отвечает ошибкой")
    MAIN_PAGE_ERROR(SiteProblemTypeEnum.MORDA_ERROR),
    @Description("главная страница сайта осуществляет редирект")
    MAIN_PAGE_REDIRECTS(SiteProblemTypeEnum.MORDA_REDIRECTS),
    @Description("проблемы с загрузкой favicon сайта")
    FAVICON_PROBLEM(SiteProblemTypeEnum.MISSING_FAVICON),
    @Description("слишком много страниц-дублей")
    TOO_MANY_PAGE_DUPLICATES(SiteProblemTypeEnum.TOO_MANY_URL_DUPLICATES),
    @Description("у сайта отсутствует файл robots.txt")
    NO_ROBOTS_TXT(SiteProblemTypeEnum.NO_ROBOTS_TXT),
    @Description("многие страницы сайта не имеют заголовка")
    DOCUMENTS_MISSING_TITLE(SiteProblemTypeEnum.DOCUMENTS_MISSING_TITLE),
    @Description("многие страницы сайта не содержат тега <meta name=\"description\" ... />")
    DOCUMENTS_MISSING_DESCRIPTION(SiteProblemTypeEnum.DOCUMENTS_MISSING_DESCRIPTION),
    @Description("содержимое файлов sitemap сайта давно не менялось")
    NO_SITEMAP_MODIFICATIONS(SiteProblemTypeEnum.NO_SITEMAP_MODIFICATIONS),
    @Description("сайт признан не мобилопригодным")
    NOT_MOBILE_FRIENDLY(SiteProblemTypeEnum.NOT_MOBILE_FRIENDLY),
    @Description("страницы сайта загружаются слишком медленно")
    SLOW_AVG_RESPONSE_TIME(SiteProblemTypeEnum.SLOW_AVG_RESPONSE_WITH_EXAMPLES),
    @Description("на сайте обнаружены нарушения или угрозы безопасности")
    THREATS(SiteProblemTypeEnum.THREATS),
    @Description("на сайте не установлен корректно работающий счетчик метрики")
    NO_METRIKA_COUNTER(SiteProblemTypeEnum.NO_METRIKA_COUNTER),
    @Description("на сайте присутствует реклама, которая считается плохой в я.браузере")
    BAD_ADVERTISEMENT(SiteProblemTypeEnum.YABROWSER_BADAD),
    // commented out since its counterpart in SiteProblemTypeEnum is added to disabled
    //@Description("на сайте присутствует видео-контент в неподдерживаемых яндексом плеерах")
    //NON_WORKING_VIDEO(SiteProblemTypeEnum.NON_WORKING_VIDEO),
    @Description("найдены ошибки при обработке турбо-фидов")
    TURBO_FEED_ERROR(SiteProblemTypeEnum.TURBO_ERROR),
    @Description("найдены предупреждения при обработке турбо-фидов")
    TURBO_FEED_WARNING(SiteProblemTypeEnum.TURBO_WARNING),
    @Description("некоторые турбо-фиды забанены")
    TURBO_FEED_BAN(SiteProblemTypeEnum.TURBO_FEED_BAN),
    @Description("некоторые турбо-страницы забанены")
    TURBO_DOCUMENT_BAN(SiteProblemTypeEnum.TURBO_DOCUMENT_BAN),
    @Description("турбо-версия сайта забанена")
    TURBO_HOST_BAN(SiteProblemTypeEnum.TURBO_HOST_BAN),
    @Description("турбо-версия сайта не соответствует рекомендациям")
    TURBO_HOST_BAN_INFO(SiteProblemTypeEnum.TURBO_HOST_BAN_INFO),
    @Description("плохое покрытие турбо-страницами поискового трафика")
    TURBO_INSUFFICIENT_CLICKS_SHARE(SiteProblemTypeEnum.TURBO_INSUFFICIENT_CLICKS_SHARE),
    // commented out since its counterpart in SiteProblemTypeEnum is added to disabled
    // @Description("в яндекс.справочнике присутствуют организации с незаполненым профилем")
    // INCOMPLETE_SPRAV_COMPANY_PROFILE(SiteProblemTypeEnum.HOST_COMPANY_PROFILE_NOT_FILLED),
    @Description("слишком много битых ссылок")
    TOO_MANY_BROKEN_LINKS(SiteProblemTypeEnum.TOO_MANY_BROKEN_LINKS),
    @Description("слишком много доменов в поиске")
    TOO_MANY_DOMAINS_ON_SEARCH(SiteProblemTypeEnum.TOO_MANY_DOMAINS_ON_SEARCH),
    @Description("главное зеркало сайта - не https")
    MAIN_MIRROR_IS_NOT_HTTPS(SiteProblemTypeEnum.MAIN_MIRROR_IS_NOT_HTTPS),
    @Description("некорректная настройка SSL-сертификата сайта")
    SSL_CERTIFICATE_ERROR(SiteProblemTypeEnum.SSL_CERTIFICATE_ERROR),
    @Description("Яндекс.Справочник создал карточку организации")
    SPRAV_COMPANY_PROFILE_CREATED(SiteProblemTypeEnum.HOST_COMPANY_PROFILE_CREATED),
    @Description("Проблемы с фавиконками на сайте")
    FAVICON_ERROR(SiteProblemTypeEnum.FAVICON_ERROR),
    @Description("Проблемы с турбо-листингами")
    TURBO_LISTING_ERROR(SiteProblemTypeEnum.TURBO_LISTING_ERROR),
    @Description("Не включен обход ни по одному привязанному счетику Метрики")
    NO_METRIKA_COUNTER_CRAWL_ENABLED(SiteProblemTypeEnum.NO_METRIKA_COUNTER_CRAWL_ENABLED),
    @Description("Турбо-страницы сайта не участвуют в поиске из-за проблем с индексированием")
    TURBO_URL_ERRORS(SiteProblemTypeEnum.TURBO_URL_ERRORS),
    @Description("Нет провязок счетчиков Метрики")
    NO_METRIKA_COUNTER_BINDING(SiteProblemTypeEnum.NO_METRIKA_COUNTER_BINDING),
    @Description("Не работает добавление в корзину на Турбо-страницах")
    TURBO_INVALID_CART_URL(SiteProblemTypeEnum.TURBO_INVALID_CART_URL),
    @Description("Отсутствует фавиконка размера 120")
    BIG_FAVICON_ABSENT(SiteProblemTypeEnum.BIG_FAVICON_ABSENT),
    @Description("найдены ошибки при обработке турбо-фидов RSS")
    TURBO_RSS_ERROR(SiteProblemTypeEnum.TURBO_RSS_ERROR),
    @Description("найдены предупреждения при обработке турбо-фидов RSS")
    TURBO_RSS_WARNING(SiteProblemTypeEnum.TURBO_RSS_WARNING),
    @Description("найдены ошибки при обработке турбо-фидов YML")
    TURBO_YML_ERROR(SiteProblemTypeEnum.TURBO_YML_ERROR),
    @Description("найдены предупреждения при обработке турбо-фидов YML")
    TURBO_YML_WARNING(SiteProblemTypeEnum.TURBO_YML_WARNING),
    @Description("Возникла ошибка при установки связи с сервером")
    CONNECT_FAILED(SiteProblemTypeEnum.CONNECT_FAILED),
    TURBO_HOST_BAN_OK(SiteProblemTypeEnum.TURBO_HOST_BAN_OK),
    INSIGNIFICANT_CGI_PARAMETER(SiteProblemTypeEnum.INSIGNIFICANT_CGI_PARAMETER),
    DUPLICATE_CONTENT_ATTRS(SiteProblemTypeEnum.DUPLICATE_CONTENT_ATTRS),
    DUPLICATE_PAGES(SiteProblemTypeEnum.DUPLICATE_PAGES),
    @Description("Алерт по четыресоткам")
    URL_ALERT_4XX(SiteProblemTypeEnum.URL_ALERT_4XX),
    @Description("Алерт по пятисоткам")
    URL_ALERT_5XX(SiteProblemTypeEnum.URL_ALERT_5XX),
    @Description("Алерт про обход robots.txt")
    DISALLOWED_URLS_ALERT(SiteProblemTypeEnum.DISALLOWED_URLS_ALERT),
    @Description("Оферта видеохостинга не прошла валидацию")
    VIDEOHOST_OFFER_FAILED(SiteProblemTypeEnum.VIDEOHOST_OFFER_FAILED),
    @Description("Нужна оферта для видеохостинга")
    VIDEOHOST_OFFER_IS_NEEDED(SiteProblemTypeEnum.VIDEOHOST_OFFER_IS_NEEDED),
    @Description("Нужно дополнительное бумажное соглашение для видеохостинга")
    VIDEOHOST_OFFER_NEED_PAPER(SiteProblemTypeEnum.VIDEOHOST_OFFER_NEED_PAPER),
    ;
    private final SiteProblemTypeEnum coreType;

    ApiSiteProblemTypeEnum(SiteProblemTypeEnum coreType) {
        this.coreType = coreType;
    }

    public SiteProblemTypeEnum getCoreType() {
        return coreType;
    }

    private static final Map<SiteProblemTypeEnum, ApiSiteProblemTypeEnum> CORE_TYPE_2_API_TYPE =
            new EnumMap<>(SiteProblemTypeEnum.class);

    static {
        for (ApiSiteProblemTypeEnum problemType : values()) {
            CORE_TYPE_2_API_TYPE.put(problemType.coreType, problemType);
        }
    }

    @Nullable
    public static ApiSiteProblemTypeEnum fromCoreType(SiteProblemTypeEnum problemType) {
        return CORE_TYPE_2_API_TYPE.get(problemType);
    }
}
