package ru.yandex.webmaster3.api.feeds.action;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.webmaster3.api.feeds.FeedsAddInfoLocator;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.meta.ApiRequestWithEntity;

/**
 * @author avhaliullin
 */
public class FeedsAddInfoRequest extends AbstractApiUserVerifiedHostRequest<FeedsAddInfoLocator> implements ApiRequestWithEntity<FeedsAddInfoRequest.Entity> {

    private Entity entity;

    @Override
    public Entity getEntity() {
        return entity;
    }

    @Override
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class Entity {
        @JsonProperty("requestId")
        UUID requestId;
    }
}
