package ru.yandex.webmaster3.api.feeds.action;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiGetResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;

/**
 * @author avhaliullin
 */
public interface FeedsAddInfoResponse extends ApiGetResponse {

    enum Errors implements ApiErrorCode {
        REQUEST_NOT_FOUND,
        TIMED_OUT,
        FEED_ALREADY_ADDED,
        BAD_HTTP_CODE,
        BAD_MIME_TYPE,
        BANNED_FEED,
    }

    enum SuccessStatus {
        IN_PROGRESS,
        OK
    }

    @Value
    class NormalResponse extends Success200 implements FeedsAddInfoResponse {
        @JsonProperty("processStatus")
        SuccessStatus processStatus;
    }

    @Description("Протокол не поддерживается")
    class RequestNotFoundResponse extends NotFound404<FeedsAddInfoResponse.Errors> implements FeedsAddInfoResponse {

        public RequestNotFoundResponse() {
            super(Errors.REQUEST_NOT_FOUND, "Request not found");
        }
    }
    @Description("Протокол не поддерживается")
    class TimedOutResponse extends NotFound404<FeedsAddInfoResponse.Errors> implements FeedsAddInfoResponse {

        public TimedOutResponse() {
            super(Errors.TIMED_OUT, "Request timed out");
        }
    }
    @Description("Протокол не поддерживается")
    class BadHttpCodeResponse extends NotFound404<FeedsAddInfoResponse.Errors> implements FeedsAddInfoResponse {

        public BadHttpCodeResponse() {
            super(Errors.BAD_HTTP_CODE, "Server answer with http code != 2xx");
        }
    }
    @Description("Протокол не поддерживается")
    class BadMimeTypeResponse extends NotFound404<FeedsAddInfoResponse.Errors> implements FeedsAddInfoResponse {

        public BadMimeTypeResponse() {
            super(Errors.BAD_MIME_TYPE, "Bad mime type");
        }
    }

    @Description("Фид был забанен")
    class BannedFeedResponse extends NotFound404<FeedsAddInfoResponse.Errors> implements FeedsAddInfoResponse {
        public BannedFeedResponse() {
            super(Errors.BANNED_FEED, "Feed was banned");
        }
    }

}
