package ru.yandex.webmaster3.api.feeds.action;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.webmaster3.api.feeds.FeedsAddStartLocator;
import ru.yandex.webmaster3.api.feeds.info.FeedInfo;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.meta.ApiRequestWithEntity;

/**
 * @author avhaliullin
 */
public class FeedsAddStartRequest extends AbstractApiUserVerifiedHostRequest<FeedsAddStartLocator>
        implements ApiRequestWithEntity<FeedsAddStartRequest.Entity> {

    private Entity entity;

    @Override
    public Entity getEntity() {
        return entity;
    }

    @Override
    public void setEntity(Entity entity) {
        this.entity = entity;
    }



    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class Entity {
        @JsonProperty("feed")
        FeedInfo feed;
    }

}
