package ru.yandex.webmaster3.api.feeds.action;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiPostResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;

/**
 * @author avhaliullin
 */
public interface FeedsAddStartResponse extends ApiPostResponse {


    enum Errors implements ApiErrorCode {
        FEEDS_LIMIT_EXCEEDED,
        ONLY_HTTPS,
        FEED_ALREADY_ADDED,
        INCORRECT_URL,
        WRONG_REGION
    }

    @Value
    class NormalResponse extends Success200 implements FeedsAddStartResponse {
        @Description("uuid запроса")
        @JsonProperty("requestId")
        UUID requestId;
    }

    @Description("Превышен лимит количества фидов")
    class FeedsLimitExceededResponse extends Forbidden403<FeedsAddStartResponse.Errors> implements FeedsAddStartResponse {
        @Description("Лимит количества добавленых фидов")

        private final int limit;

        public FeedsLimitExceededResponse(int limit) {
            super(Errors.FEEDS_LIMIT_EXCEEDED, "Feeds count limit exceeded - max feeds allowed: " + limit);
            this.limit = limit;
        }

        public int getLimit() {
            return limit;
        }
    }

    @Description("Превышен лимит количества фидов")
    class WrongRegionResponse extends Forbidden403<FeedsAddStartResponse.Errors> implements FeedsAddStartResponse {
        @Description("Лимит количества добавленых фидов")
        @JsonProperty("regionId")

        private final int regionId;

        public WrongRegionResponse(int regionId) {
            super(Errors.WRONG_REGION, "Wrong region with id: " + regionId);
            this.regionId = regionId;
        }

        public int getRegionId() {
            return regionId;
        }
    }

    @Description("Протокол не поддерживается")
    class FeedsProtocolUnsupportedResponse extends NotFound404<FeedsAddStartResponse.Errors> implements FeedsAddStartResponse {

        public FeedsProtocolUnsupportedResponse() {
            super(Errors.ONLY_HTTPS, "Expected HTTPS protocol");
        }
    }

    @Description("Протокол не поддерживается")
    class FeedAlreadyAddedResponse extends NotFound404<FeedsAddStartResponse.Errors> implements FeedsAddStartResponse {

        public FeedAlreadyAddedResponse() {
            super(Errors.FEED_ALREADY_ADDED, "Feed already exist");
        }
    }

    @Description("Протокол не поддерживается")
    class IncorrectUrlResponse extends NotFound404<FeedsAddStartResponse.Errors> implements FeedsAddStartResponse {

        public IncorrectUrlResponse() {
            super(Errors.INCORRECT_URL, "Expected correct url");
        }
    }
}
