package ru.yandex.webmaster3.api.feeds.action;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiPostResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;

/**
 * @author avhaliullin
 */
public interface FeedsBatchAddResponse extends ApiPostResponse {

    enum Errors implements ApiErrorCode {
        FEEDS_LIMIT_EXCEEDED,
        BATCH_LIMIT_EXCEEDED
    }

    @AllArgsConstructor
    enum AddStatus {
        OK,
        NOT_HTTPS,
        FEED_ALREADY_ADDED,
        BAD_HTTP_CODE,
        BAD_MIME_TYPE,
        TIMED_OUT,
        INCORRECT_URL,
        BANNED_FEED,
        WRONG_REGION
    }

    @Value
    class NormalResponse extends Success200 implements FeedsBatchAddResponse {
        @JsonProperty("feeds")
        List<AddFeedInfo> feeds;
    }

    @Value
    class AddFeedInfo {
        @JsonProperty("url")
        String url;
        @JsonProperty("status")
        AddStatus status;
    }

    @Description("Много урлов")
    class FeedsLimitExceededResponse extends Forbidden403<FeedsBatchAddResponse.Errors> implements FeedsBatchAddResponse {

        public FeedsLimitExceededResponse(int limit) {
            super(Errors.FEEDS_LIMIT_EXCEEDED, "Feeds count limit exceeded - max feeds allowed: " + limit);
        }
    }

    @Description("Много урлов")
    class BatchLimitExceededResponse extends Forbidden403<FeedsBatchAddResponse.Errors> implements FeedsBatchAddResponse {

        public BatchLimitExceededResponse(int limit) {
            super(Errors.BATCH_LIMIT_EXCEEDED, "Batch count limit exceeded - max feeds allowed in one batch: " + limit);
        }
    }

}
