package ru.yandex.webmaster3.api.feeds.action;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.ActionPermission;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.feeds.FeedsService;

/**
 * @author avhaliullin
 */
@Slf4j
@RequiredArgsConstructor
@Description("Получить список фидов для домена")
@Category("feeds")
@Component
@ActionPermission(Permission.COMMON)
public class FeedsBatchRemoveAction extends AbstractApiAction<FeedsBatchRemoveRequest, FeedsBatchRemoveResponse> {
    private final FeedsService feedsService;

    @Override
    public FeedsBatchRemoveResponse process(FeedsBatchRemoveRequest request) {
        WebmasterHostId hostId = request.getHostId();
        String domain = WwwUtil.cutWWWAndM(hostId);

        List<String> urls = request.getEntity().getUrls();
        if (urls.size() > FeedsService.LIMIT_FEEDS_ON_DOMAIN) {
            return new FeedsBatchRemoveResponse.ManyUrlsForRemoveResponse(FeedsService.LIMIT_FEEDS_ON_DOMAIN);
        }
        List<FeedsBatchRemoveResponse.RemovedFeedInfo> removedFeedInfos = urls.stream()
                .map(url -> FeedsBatchRemoveResponse.RemovedFeedInfo.of(url, feedsService.removeFeed(domain, url)))
                .toList();

        return new FeedsBatchRemoveResponse.NormalResponse(removedFeedInfos);
    }
}
