package ru.yandex.webmaster3.api.feeds.action;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.webmaster3.api.feeds.FeedsBatchRemoveLocator;
import ru.yandex.webmaster3.api.host.filter.trait.AbstractApiUserVerifiedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.meta.ApiRequestWithEntity;

/**
 * @author avhaliullin
 */
public class FeedsBatchRemoveRequest extends AbstractApiUserVerifiedHostRequest<FeedsBatchRemoveLocator> implements ApiRequestWithEntity<FeedsBatchRemoveRequest.Entity> {

    private Entity entity;

    @Override
    public Entity getEntity() {
        return entity;
    }

    @Override
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class Entity {
        @JsonProperty("urls")
        List<String> urls;
    }
}
