package ru.yandex.webmaster3.api.feeds.action;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiDeleteResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.core.util.W3Collectors;
import ru.yandex.webmaster3.storage.feeds.FeedsService;

/**
 * @author avhaliullin
 */
public interface FeedsBatchRemoveResponse extends ApiDeleteResponse {

    enum Errors implements ApiErrorCode {
        MANY_URLS_FOR_REMOVE
    }

    @AllArgsConstructor
    enum RemoveStatus {
        OK(FeedsService.RemoveFeedStatus.OK),
        NOT_EXIST(FeedsService.RemoveFeedStatus.NOT_EXIST),
        ;
        private static final EnumMap<FeedsService.RemoveFeedStatus, RemoveStatus> R =
                Arrays.stream(values()).map(x -> Pair.of(x.wmStatus, x))
                        .collect(W3Collectors.toEnumMap(FeedsService.RemoveFeedStatus.class));
        private final FeedsService.RemoveFeedStatus wmStatus;
    }

    @Value
    class NormalResponse extends Success200 implements FeedsBatchRemoveResponse {
        @JsonProperty("feeds")
        List<RemovedFeedInfo> feeds;
    }

    @Value
    class RemovedFeedInfo {
        @JsonProperty("url")
        String url;
        @JsonProperty("status")
        RemoveStatus status;

        public static RemovedFeedInfo of(String url, FeedsService.RemoveFeedStatus status) {
            return new RemovedFeedInfo(url, RemoveStatus.R.get(status));
        }
    }

    @Description("Слишком много урлов")
    class ManyUrlsForRemoveResponse extends Forbidden403<FeedsBatchRemoveResponse.Errors> implements FeedsBatchRemoveResponse {

        public ManyUrlsForRemoveResponse(int limit) {
            super(Errors.MANY_URLS_FOR_REMOVE, "Urls count limit exceeded - max urls allowed: " + limit);
        }
    }

}
