package ru.yandex.webmaster3.api.feeds.action;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.feeds.info.FeedInfo;
import ru.yandex.webmaster3.api.feeds.info.FeedType;
import ru.yandex.webmaster3.api.http.auth.ActionPermission;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.feeds.feed.NativeFeedInfo2;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.feeds.FeedsNative2YDao;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor
@Description("Получить список фидов для домена")
@Category("feeds")
@Component
@ActionPermission(Permission.COMMON)
public class FeedsListAction extends AbstractApiAction<FeedsListRequest, FeedsListResponse> {
    private final FeedsNative2YDao feedsNativeYDao;

    @Override
    public FeedsListResponse process(FeedsListRequest request) {
        WebmasterHostId hostId = request.getHostId();
        String domain = WwwUtil.cutWWWAndM(hostId);
        List<NativeFeedInfo2> rawFeedInfos = feedsNativeYDao.list(domain);
        List<FeedInfo> feedsItems =
                rawFeedInfos.stream()
                        .map(NativeFeedInfo2::toUrlWithUserInfo)
                        .map(x -> new FeedInfo(x.getUrl(), x.getRegionsId(), FeedType.R.get(x.getType()))).toList();

        return new FeedsListResponse(feedsItems);
    }
}
