package ru.yandex.webmaster3.api.feeds.info;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import lombok.With;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author kravchenko99
 * @date 6/1/22
 */

@Value
@With
public class FeedInfo {
    @Description("URL фида, например - https://www.yandex.ru/feed.xml или https://login@password:www.yandex.ru/feed.xml")
    @JsonProperty("url")
    String url;
    @Description("Регионы")
    @JsonProperty("regionIds")
    List<Integer> regionIds;
    @Description("Тип фида")
    @JsonProperty("type")
    FeedType type;
}
