package ru.yandex.webmaster3.api.feeds.info;

import java.util.Arrays;
import java.util.EnumMap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;
import ru.yandex.webmaster3.core.util.W3Collectors;

@RequiredArgsConstructor
@Getter
public enum FeedType {
    @Description("Недвижимость")
    REALTY(NativeFeedType.REALTY),
    @Description("Вакансии")
    VACANCY(NativeFeedType.VACANCY),
    @Description("Врачи")
    DOCTORS(NativeFeedType.DOCTORS),
    @Description("Транспортные средства")
    CARS(NativeFeedType.CARS),
    @Description("Товары")
    GOODS(NativeFeedType.STORES),
    @Description("Исполнители")
    SERVICES(NativeFeedType.SERVICES),
    @Description("Образование")
    EDUCATION(NativeFeedType.EDUCATION),
    @JsonIgnore
    @Description("Гео")

    GEOORG(NativeFeedType.GEOORG)
    ;

    public static final EnumMap<NativeFeedType, FeedType> R =
            Arrays.stream(values()).map(x -> Pair.of(x.typeWm, x))
                    .collect(W3Collectors.toEnumMap(NativeFeedType.class));
    private final NativeFeedType typeWm;
}
