package ru.yandex.webmaster3.api.host.action;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.auth.ActionPermission;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.events2.HostEventId;
import ru.yandex.webmaster3.core.host.verification.UserHostVerificationInfo;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.user.dao.UserHostVerificationYDao;
import ru.yandex.webmaster3.storage.user.service.InitializedUsersService;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;
import ru.yandex.webmaster3.storage.verification.HostVerifierService;

/**
 * @author avhaliullin
 */
@Description("Добавить сайт в список сайтов пользователя")
@Category("host")
@Component
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@ActionPermission(Permission.COMMON)
public class AddHostAction extends AbstractApiAction<AddHostRequest, AddHostResponse> {

    private static final int HOST_LIST_LIMIT = 1703;

    private final HostVerifierService hostVerifierService;
    private final UserHostVerificationYDao userHostVerificationYDao;
    private final UserHostsService userHostsService;
    private final InitializedUsersService initializedUsersService;

    @Override
    public AddHostResponse process(AddHostRequest request) {
        long userId = request.getUserId();

        //Dirtiest hack ever
        if (userId == 48240828L) {
            return new AddHostResponse.HostsLimitExceededResponse(HOST_LIST_LIMIT);
        }
        //endhack

        WebmasterUser user = new WebmasterUser(userId);
        WebmasterHostId hostId = IdUtils.urlToHostIdWithUpgradedValidation(request.getHostUrl());
        UserHostVerificationInfo verificationInfo = null;
        // Проверяем, не добавлен ли хост уже
        if (userHostsService.getVerifiedHost(user, hostId) != null) {
            return new AddHostResponse.HostAlreadyAddedResponse(userId, hostId, true);
        }
        verificationInfo = userHostVerificationYDao.getLatestRecord(userId, hostId);
        if (verificationInfo != null && verificationInfo.isAddedToList()) {
            return new AddHostResponse.HostAlreadyAddedResponse(userId, hostId, false);
        }

        if (userHostsService.getAllHostsCount(user) >= HOST_LIST_LIMIT) {
            return new AddHostResponse.HostsLimitExceededResponse(HOST_LIST_LIMIT);
        }

        // честная инициализация подписывает пользователя на рассылки, для api это не нужно,
        // но нужно завести UUID для этого пользователя
        initializedUsersService.createUUIDRecordIfNeeded(userId);
        HostEventId eventId = HostEventId.createFromUserRequest(request.getBalancerRequestId(), userId);
        hostVerifierService.addHostUinInitRecord(user, hostId, verificationInfo, eventId);

        return new AddHostResponse.NormalResponse(userId, hostId);
    }

}
