package ru.yandex.webmaster3.api.host.action;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.HostListLocator;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.api.http.rest.request.meta.ApiRequestWithEntity;
import ru.yandex.webmaster3.api.user.filter.AbstractApiUserRequest;

import java.net.URL;

/**
 * @author avhaliullin
 */
public class AddHostRequest extends AbstractApiUserRequest<HostListLocator> implements ApiRequestWithEntity<AddHostRequest.Entity> {
    private Entity entity;

    @Override
    public Entity getEntity() {
        return entity;
    }

    @Override
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public URL getHostUrl() {
        return entity.getHostUrl();
    }

    public static class Entity {
        private final URL hostUrl;

        @JsonCreator
        public Entity(@Description("URL сайта, например - https://www.yandex.ru") URL hostUrl) {
            this.hostUrl = hostUrl;
        }

        public URL getHostUrl() {
            return hostUrl;
        }
    }
}
