package ru.yandex.webmaster3.api.host.action;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.data.ApiHostInfo;
import ru.yandex.webmaster3.api.host.data.IHostInfo;
import ru.yandex.webmaster3.api.http.auth.Permission;
import ru.yandex.webmaster3.api.http.rest.AbstractApiAction;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.storage.host.service.MirrorService2;
import ru.yandex.webmaster3.storage.user.UserUnverifiedHost;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;

/**
 * @author avhaliullin
 */
@Description("Получить список сайтов, добавленных пользователем")
@Category("host")
@Component
public class GetHostListAction extends AbstractApiAction<GetHostListRequest, GetHostListResponse> {
    @Autowired
    private UserHostsService userHostsService;
    @Autowired
    private MirrorService2 mirrorService2;

    public GetHostListAction() {
        super(Permission.HOST_LIST);
    }

    @Override
    public GetHostListResponse process(GetHostListRequest request) {
        WebmasterUser user = new WebmasterUser(request.getUserId());
        List<UserVerifiedHost> verifiedHosts = userHostsService.getVerifiedHosts(user);
        List<UserUnverifiedHost> unverifiedHosts = userHostsService.getMayBeUnverifiedHosts(user);
        Map<WebmasterHostId, ApiHostInfo> results = new HashMap<>();
        for (UserVerifiedHost verifiedHost : verifiedHosts) {
            results.put(verifiedHost.getWebmasterHostId(), new ApiHostInfo(verifiedHost.getWebmasterHostId(), true));
        }
        for (UserUnverifiedHost unverifiedHost : unverifiedHosts) {
            if (!results.containsKey(unverifiedHost.getWebmasterHostId())) {
                results.put(unverifiedHost.getWebmasterHostId(), new ApiHostInfo(unverifiedHost.getWebmasterHostId(), false));
            }
        }

        Map<WebmasterHostId, WebmasterHostId> mainMirrors = mirrorService2.getMainMirrors(results.keySet());

        List<GetHostListResponse.HostListItem> items = new ArrayList<>();
        for (ApiHostInfo hostInfo : results.values()) {
            WebmasterHostId mainMirrorId = mainMirrors.get(hostInfo.getHostId());
            Optional<IHostInfo> mainMirrorInfoOpt;
            if (mainMirrorId != null && !mainMirrorId.equals(hostInfo.getHostId())) {
                ApiHostInfo mainMirrorInfo = results.get(mainMirrorId);
                if (mainMirrorInfo == null) {
                    mainMirrorInfoOpt = Optional.of(new ApiHostInfo(mainMirrorId, false));
                } else {
                    mainMirrorInfoOpt = Optional.of(mainMirrorInfo);
                }
            } else {
                mainMirrorInfoOpt = Optional.empty();
            }
            items.add(GetHostListResponse.HostListItem.create(hostInfo, mainMirrorInfoOpt));
        }
        items.sort(Comparator.comparing(hostInfo -> hostInfo.getHostId().getReadableHostname()));
        return new GetHostListResponse(items);
    }
}
