package ru.yandex.webmaster3.api.host.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.data.ASCIIHostUrl;
import ru.yandex.webmaster3.api.host.data.ApiHostInfo;
import ru.yandex.webmaster3.api.host.data.IHostInfo;
import ru.yandex.webmaster3.api.host.data.UnicodeHostUrl;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.List;
import java.util.Optional;

/**
 * @author avhaliullin
 */
public class GetHostListResponse extends ApiResponse.Success200 {
    private final List<HostListItem> hosts;

    public GetHostListResponse(List<HostListItem> hosts) {
        this.hosts = hosts;
    }

    @Description("список хостов пользователя")
    public List<HostListItem> getHosts() {
        return hosts;
    }

    public static class HostListItem implements IHostInfo {
        private final WebmasterHostId hostId;
        private final ASCIIHostUrl asciiHostUrl;
        private final UnicodeHostUrl unicodeHostUrl;
        private final boolean verified;
        private final Optional<IHostInfo> mainMirror;

        public HostListItem(WebmasterHostId hostId, boolean verified, Optional<IHostInfo> mainMirror) {
            this.hostId = hostId;
            this.asciiHostUrl = ASCIIHostUrl.fromHostId(hostId);
            this.unicodeHostUrl = UnicodeHostUrl.fromHostId(hostId);
            this.verified = verified;
            this.mainMirror = mainMirror;
        }

        @Override
        public WebmasterHostId getHostId() {
            return hostId;
        }

        @Override
        public ASCIIHostUrl getAsciiHostUrl() {
            return asciiHostUrl;
        }

        @Override
        public UnicodeHostUrl getUnicodeHostUrl() {
            return unicodeHostUrl;
        }

        @Override
        public boolean isVerified() {
            return verified;
        }

        @Description("главное зеркало, если есть")
        public Optional<IHostInfo> getMainMirror() {
            return mainMirror;
        }

        public static HostListItem create(ApiHostInfo hostInfo, Optional<IHostInfo> mainMirror) {
            return new HostListItem(hostInfo.getHostId(), hostInfo.isVerified(), mainMirror);
        }
    }
}
