package ru.yandex.webmaster3.api.host.action;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.host.data.ASCIIHostUrl;
import ru.yandex.webmaster3.api.host.data.ApiHostDataStatus;
import ru.yandex.webmaster3.api.host.data.ApiHostInfo;
import ru.yandex.webmaster3.api.host.data.IHostInfo;
import ru.yandex.webmaster3.api.host.data.UnicodeHostUrl;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Optional;

/**
 * @author avhaliullin
 */
public class HostInfoResponse extends ApiResponse.Success200 implements IHostInfo {
    private final WebmasterHostId hostId;
    private final boolean verified;
    private final ASCIIHostUrl asciiHostUrl;
    private final UnicodeHostUrl unicodeHostUrl;
    private final Optional<ApiHostInfo> mainMirror;
    private final Optional<ApiHostDataStatus> hostDataStatus;
    private final Optional<String> hostDisplayName;

    public HostInfoResponse(WebmasterHostId hostId, boolean verified, Optional<ApiHostInfo> mainMirror,
                            Optional<ApiHostDataStatus> hostDataStatus, Optional<String> hostDisplayName) {
        this.hostId = hostId;
        this.verified = verified;
        this.unicodeHostUrl = UnicodeHostUrl.fromHostId(hostId);
        this.asciiHostUrl = ASCIIHostUrl.fromHostId(hostId);
        this.mainMirror = mainMirror;
        this.hostDataStatus = hostDataStatus;
        this.hostDisplayName = hostDisplayName;
    }

    @Override
    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public boolean isVerified() {
        return verified;
    }

    @Override
    public ASCIIHostUrl getAsciiHostUrl() {
        return asciiHostUrl;
    }

    @Override
    public UnicodeHostUrl getUnicodeHostUrl() {
        return unicodeHostUrl;
    }

    @Description("Главное зеркало, если есть")
    public Optional<ApiHostInfo> getMainMirror() {
        return mainMirror;
    }

    @Description("Текущее состояние данных о хосте (показывается, если хост подтвержден)")
    public Optional<ApiHostDataStatus> getHostDataStatus() {
        return hostDataStatus;
    }

    @Description("Имя сайта, использующееся на выдаче - например Akbars-Development.ru (показывается, если хост подтвержден)")
    public Optional<String> getHostDisplayName() {
        return hostDisplayName;
    }
}
