package ru.yandex.webmaster3.api.host.action.v31;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;

import java.util.Map;

/**
 * @author avhaliullin
 */
public class GetHostSummaryResponse extends ApiResponse.Success200 {
    private final int tic;
    private final long downloadedPagesCount;
    private final long excludedPagesCount;
    private final long searchablePagesCount;
    private final Map<SiteProblemSeverityEnum, Integer> siteProblems;

    public GetHostSummaryResponse(int tic, long downloadedPagesCount,
                                  long excludedPagesCount, long searchablePagesCount, Map<SiteProblemSeverityEnum, Integer> siteProblems) {
        this.tic = tic;
        this.downloadedPagesCount = downloadedPagesCount;
        this.excludedPagesCount = excludedPagesCount;
        this.searchablePagesCount = searchablePagesCount;
        this.siteProblems = siteProblems;
    }

    @Description("тИЦ сайта")
    public int getTic() {
        return tic;
    }

    @Description("Количество страниц, загруженных роботом")
    public long getDownloadedPagesCount() {
        return downloadedPagesCount;
    }

    @Description("Количество исключенных страниц")
    public long getExcludedPagesCount() {
        return excludedPagesCount;
    }

    @Description("Количество страниц в поиске")
    public long getSearchablePagesCount() {
        return searchablePagesCount;
    }

    @Description("Количество найденых на сайте проблем по степени серьезности")
    public Map<SiteProblemSeverityEnum, Integer> getSiteProblems() {
        return siteProblems;
    }
}
