package ru.yandex.webmaster3.api.host.action.v32;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;

import java.util.Map;

/**
 * @author avhaliullin
 */
public class GetHostSummaryV32Response extends ApiResponse.Success200 {
    private final int sqi;
    private final int tic;
    private final long downloadedPagesCount;
    private final long excludedPagesCount;
    private final long searchablePagesCount;
    private final Map<SiteProblemSeverityEnum, Integer> siteProblems;

    public GetHostSummaryV32Response(int sqi, int tic, long downloadedPagesCount,
                                     long excludedPagesCount, long searchablePagesCount, Map<SiteProblemSeverityEnum, Integer> siteProblems) {
        this.sqi = sqi;
        this.tic = tic;
        this.downloadedPagesCount = downloadedPagesCount;
        this.excludedPagesCount = excludedPagesCount;
        this.searchablePagesCount = searchablePagesCount;
        this.siteProblems = siteProblems;
    }

    @Description("Значение Site Quality Index (ИКС) сайта")
    public int getSqi() {
        return sqi;
    }

    @Description("тИЦ сайта")
    public int getTic() {
        return tic;
    }

    @Description("Количество страниц, загруженных роботом")
    public long getDownloadedPagesCount() {
        return downloadedPagesCount;
    }

    @Description("Количество исключенных страниц")
    public long getExcludedPagesCount() {
        return excludedPagesCount;
    }

    @Description("Количество страниц в поиске")
    public long getSearchablePagesCount() {
        return searchablePagesCount;
    }

    @Description("Количество найденых на сайте проблем по степени серьезности")
    public Map<SiteProblemSeverityEnum, Integer> getSiteProblems() {
        return siteProblems;
    }
}
