package ru.yandex.webmaster3.api.host.action.v41;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;

import java.util.Map;

/**
 * @author leonidrom
 */
public class GetHostSummaryV41Response extends ApiResponse.Success200 {
    private final int sqi;
    private final long excludedPagesCount;
    private final long searchablePagesCount;
    private final Map<SiteProblemSeverityEnum, Integer> siteProblems;

    public GetHostSummaryV41Response(int sqi, long excludedPagesCount, long searchablePagesCount, Map<SiteProblemSeverityEnum, Integer> siteProblems) {
        this.sqi = sqi;
        this.excludedPagesCount = excludedPagesCount;
        this.searchablePagesCount = searchablePagesCount;
        this.siteProblems = siteProblems;
    }

    @Description("Значение Site Quality Index (ИКС) сайта")
    public int getSqi() {
        return sqi;
    }

    @Description("Количество исключенных страниц")
    public long getExcludedPagesCount() {
        return excludedPagesCount;
    }

    @Description("Количество страниц в поиске")
    public long getSearchablePagesCount() {
        return searchablePagesCount;
    }

    @Description("Количество найденых на сайте проблем по степени серьезности")
    public Map<SiteProblemSeverityEnum, Integer> getSiteProblems() {
        return siteProblems;
    }
}