package ru.yandex.webmaster3.api.host.data;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * @author avhaliullin
 */
public class ASCIIHostUrl {
    private final String url;

    private ASCIIHostUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return url;
    }

    public String toString() {
        return url;
    }

    public static ASCIIHostUrl fromHostId(WebmasterHostId hostId) {
        return hostId == null ? null : new ASCIIHostUrl(IdUtils.hostIdToUrl(hostId) + "/");
    }
}
