package ru.yandex.webmaster3.api.host.data;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class ApiHostInfo implements IHostInfo {
    private final WebmasterHostId hostId;
    private final ASCIIHostUrl asciiHostUrl;
    private final UnicodeHostUrl unicodeHostUrl;
    private final boolean verified;

    public ApiHostInfo(WebmasterHostId hostId, boolean verified) {
        this.hostId = hostId;
        this.asciiHostUrl = ASCIIHostUrl.fromHostId(hostId);
        this.unicodeHostUrl = UnicodeHostUrl.fromHostId(hostId);
        this.verified = verified;
    }

    @Override
    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public ASCIIHostUrl getAsciiHostUrl() {
        return asciiHostUrl;
    }

    @Override
    public UnicodeHostUrl getUnicodeHostUrl() {
        return unicodeHostUrl;
    }

    @Override
    public boolean isVerified() {
        return verified;
    }
}
