package ru.yandex.webmaster3.api.host.data;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

/**
 * Только для использования в response
 * @author avhaliullin
 */
public class UnicodeHostUrl {
    private final String url;

    private UnicodeHostUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return url;
    }

    public String toString() {
        return url;
    }

    public static UnicodeHostUrl fromHostId(WebmasterHostId hostId) {
        return hostId == null ? null : new UnicodeHostUrl(IdUtils.hostIdToReadableUrl(hostId) + "/");
    }
}
