package ru.yandex.webmaster3.api.host.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public interface ApiUserAddedHostError extends ApiErrorResponse<ApiUserAddedHostError.Codes> {
    enum Codes implements ApiErrorCode {
        HOST_NOT_FOUND,
    }

    @Description("Сайт отсутствует в списке сайтов пользователя")
    class HostNotFoundError extends NotFound404<Codes> implements ApiUserAddedHostError {
        private final WebmasterHostId hostId;
        public HostNotFoundError(WebmasterHostId hostId) {
            super(Codes.HOST_NOT_FOUND, "Host not found in user's host list");
            this.hostId = hostId;
        }

        @Description("id запрошенного хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }
    }
}
