package ru.yandex.webmaster3.api.host.filter;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.api.host.filter.trait.ApiUserAddedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestFilter;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.host.verification.UserHostVerificationInfo;
import ru.yandex.webmaster3.core.data.UserAddedHost;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;

/**
 * @author avhaliullin
 */
public class ApiUserAddedHostFilter<Req extends ApiRequest<?> & ApiUserAddedHostRequest> implements ApiRequestFilter<Req, ApiUserAddedHostError> {
    private UserHostsService userHostsService;

    @Override
    public ApiUserAddedHostError applyFilter(Req req) {
        WebmasterHostId hostId = req.getHostId();
        UserVerifiedHost userVerifiedHost = userHostsService.getVerifiedHost(new WebmasterUser(req.getUserId()), hostId);
        if (userVerifiedHost != null) {
            req.setUserAddedHost(new UserAddedHost(hostId, userVerifiedHost.getVerificationUin(), true));
            return null;
        }
        UserHostVerificationInfo verificationInfo = userHostsService.getVerificationInfo(req.getUserId(), hostId);
        if (verificationInfo != null && verificationInfo.isAddedToList()) {
            req.setUserAddedHost(new UserAddedHost(hostId, verificationInfo.getVerificationUin(), false));
            return null;
        }
        return new ApiUserAddedHostError.HostNotFoundError(hostId);
    }

    @Required
    public void setUserHostsService(UserHostsService userHostsService) {
        this.userHostsService = userHostsService;
    }
}
