package ru.yandex.webmaster3.api.host.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public interface ApiUserVerifiedHostError extends ApiErrorResponse<ApiUserVerifiedHostError.Codes> {
    enum Codes implements ApiErrorCode {
        HOST_NOT_VERIFIED,
    }

    @Description("Сайт не добавлен в список сайтов или права на сайт не подтверждены пользователем")
    class HostNotVerifiedError extends NotFound404<Codes> implements ApiUserVerifiedHostError {
        private final WebmasterHostId hostId;

        public HostNotVerifiedError(WebmasterHostId hostId) {
            super(Codes.HOST_NOT_VERIFIED, "Host not verified by user");
            this.hostId = hostId;
        }

        @Description("id запрошенного хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }
    }
}
