package ru.yandex.webmaster3.api.host.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public interface HostIsIndexedError extends ApiErrorResponse<HostIsIndexedError.Codes> {
    enum Codes implements ApiErrorCode {
        HOST_NOT_INDEXED,
    }

    @Description("Сайт еще не проиндексирован")
    class HostNotIndexedError extends ApiResponse.NotFound404<Codes> implements HostIsIndexedError {
        private WebmasterHostId hostId;

        public HostNotIndexedError(WebmasterHostId hostId) {
            super(Codes.HOST_NOT_INDEXED, "Host \"" + hostId + "\" is not indexed yet");
        }

        @Description("id хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }
    }
}
