package ru.yandex.webmaster3.api.host.filter;

import ru.yandex.webmaster3.api.host.filter.trait.IndexedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestFilter;
import ru.yandex.webmaster3.storage.host.HostIndicatorsDiff;

/**
 * @author avhaliullin
 */
public class HostIsIndexedFilter<Req extends ApiRequest<?> & IndexedHostRequest> implements ApiRequestFilter<Req, HostIsIndexedError> {
    @Override
    public HostIsIndexedError applyFilter(Req req) {
        HostIndicatorsDiff diff = req.getHostDataState().getHostIndicatorsDiff();
        if (diff == null || diff.getCurrentInfo() == null || diff.getCurrentInfo().getIndexedPages() == 0L) {
            return new HostIsIndexedError.HostNotIndexedError(req.getHostId());
        }
        return null;
    }
}
