package ru.yandex.webmaster3.api.host.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public interface HostIsLoadedError extends ApiErrorResponse<HostIsLoadedError.Codes> {
    enum Codes implements ApiErrorCode {
        HOST_NOT_LOADED,
    }

    @Description("Данные о сайте еще не загружены в вебмастер")
    class HostNotLoadedError extends ApiResponse.NotFound404<Codes> implements HostIsLoadedError {
        private WebmasterHostId hostId;

        public HostNotLoadedError(WebmasterHostId hostId) {
            super(Codes.HOST_NOT_LOADED, "Host \"" + hostId + "\" is not loaded in Ya.Webmaster yet");
        }

        @Description("id хоста")
        public WebmasterHostId getHostId() {
            return hostId;
        }
    }
}
