package ru.yandex.webmaster3.api.host.filter;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.api.host.filter.trait.LoadedHostRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequest;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestFilter;
import ru.yandex.webmaster3.storage.host.HostDataState;
import ru.yandex.webmaster3.storage.sitestructure.SiteStructureService;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class HostIsLoadedFilter<Req extends ApiRequest<?> & LoadedHostRequest> implements ApiRequestFilter<Req, HostIsLoadedError> {
    private final SiteStructureService siteStructureService;

    @Override
    public HostIsLoadedError applyFilter(Req req) {
        HostDataState hostDataState = siteStructureService.getHostDataState(req.getHostId());
        if (hostDataState == null) {
            return new HostIsLoadedError.HostNotLoadedError(req.getHostId());
        }
        req.setHostDataState(hostDataState);
        return null;
    }
}
