package ru.yandex.webmaster3.api.host.filter.trait;

import ru.yandex.webmaster3.api.http.common.request.locator.AbstractHostLocator;
import ru.yandex.webmaster3.api.user.filter.AbstractApiUserRequest;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.UserAddedHost;

/**
 * @author avhaliullin
 */
public abstract class AbstractApiUserAddedHostRequest<Locator extends AbstractHostLocator>
        extends AbstractApiUserRequest<Locator>
        implements ApiUserAddedHostRequest {
    private UserAddedHost userAddedHost;

    @Override
    public void setUserAddedHost(UserAddedHost userAddedHost) {
        this.userAddedHost = userAddedHost;
    }

    @Override
    public UserAddedHost getUserAddedHost() {
        return userAddedHost;
    }

    @Override
    public WebmasterHostId getHostId() {
        return getLocator().getHostId();
    }
}
