package ru.yandex.webmaster3.api.host.filter.trait;

import ru.yandex.webmaster3.api.http.common.request.locator.AbstractHostLocator;
import ru.yandex.webmaster3.api.user.filter.AbstractApiUserRequest;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;

/**
 * @author avhaliullin
 */
public abstract class AbstractApiUserVerifiedHostRequest<Locator extends AbstractHostLocator>
        extends AbstractApiUserRequest<Locator> implements ApiUserVerifiedHostRequest {
    private UserVerifiedHost userVerifiedHost;

    @Override
    public void setUserVerifiedHost(UserVerifiedHost userVerifiedHost) {
        this.userVerifiedHost = userVerifiedHost;
    }

    @Override
    public UserVerifiedHost getUserVerifiedHost() {
        return userVerifiedHost;
    }

    @Override
    public WebmasterHostId getHostId() {
        return getLocator().getHostId();
    }
}
