package ru.yandex.webmaster3.api.http;

import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author avhaliullin
 */
public class NoResourceTerminatorHandler extends AbstractHandler {
    private static final String BODY = "Resource not found";

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        baseRequest.setHandled(true);
        response.setStatus(404);
        response.setContentType("text/plain; charset=UTF-8");
        response.getWriter().write(BODY);
    }
}
