package ru.yandex.webmaster3.api.http.auth;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.api.http.rest.response.ApiResponse;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorCode;
import ru.yandex.webmaster3.api.http.rest.response.errors.ApiErrorResponse;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * @author avhaliullin
 */
public interface OAuthAuthorizerError extends ApiErrorResponse<OAuthAuthorizerError.Code> {
    enum Code implements ApiErrorCode {
        INVALID_OAUTH_TOKEN,
        ACCESS_FORBIDDEN,
    }

    @Description("OAuth токен отсутствует, или невалидный")
    class InvalidToken extends ApiResponse.Forbidden403<Code> implements OAuthAuthorizerError {
        public InvalidToken(String message) {
            super(Code.INVALID_OAUTH_TOKEN, message);
        }
    }

    @Description("Действие недоступно, у приложения нет требуемых разрешений")
    class AccessForbidden extends ApiResponse.Forbidden403<Code> implements OAuthAuthorizerError {
        public AccessForbidden() {
            super(Code.ACCESS_FORBIDDEN, "Access to this resource is not allowed with scopes available for this application");
        }

        public AccessForbidden(Permission requiredPermission, List<Permission> appPermissions) {
            super(
                Code.ACCESS_FORBIDDEN,
               "Access to this resource is not allowed with scopes available for this application. " +
                       "Required scope: " + requiredPermission + ", application scopes: " + Arrays.toString(appPermissions.toArray())
            );
        }
    }
}
