package ru.yandex.webmaster3.api.http.auth;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author avhaliullin
 */
public enum OAuthScope {
    OLD_WMC_COMMON_ACTIONS("webmaster", "verify", Permission.COMMON, Permission.ALL_SCOPES, Permission.HOST_LIST),
    OLD_WMC_EXTERNAL_LINKS("webmaster", "hostinfo", Permission.EXTERNAL_LINKS, Permission.ALL_SCOPES, Permission.HOST_LIST),
    TURBO("webmaster", "turbopages", Permission.TURBO, Permission.ALL_SCOPES, Permission.HOST_LIST),
    ALL("webmaster3", "all", Permission.COMMON, Permission.EXTERNAL_LINKS, Permission.ALL_SCOPES, Permission.TURBO, Permission.HOST_LIST),;

    private final String service;
    private final String scope;
    private final Set<Permission> permissions;

    OAuthScope(String service, String scope, Permission p1, Permission... permissions) {
        this.service = service;
        this.scope = scope;
        this.permissions = EnumSet.of(p1, permissions);
    }

    public String getService() {
        return service;
    }

    public String getScope() {
        return scope;
    }

    public Set<Permission> getPermissions() {
        return permissions;
    }

    public static OAuthScope getScope(String service, String scope) {
        Map<String, OAuthScope> map = SCOPES.get(service);
        if (map != null) {
            return map.get(scope);
        }
        return null;
    }

    private static final Map<String, Map<String, OAuthScope>> SCOPES;

    static {
        SCOPES = new HashMap<>();
        for (OAuthScope scope : values()) {
            SCOPES.computeIfAbsent(scope.getService(), ign -> new HashMap<>())
                    .put(scope.getScope(), scope);
        }
    }
}
