package ru.yandex.webmaster3.api.http.common.data;

import java.util.Map;

import org.joda.time.DateTime;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.link.DatePoint;
import ru.yandex.webmaster3.core.util.TimeUtils;

/**
 * @author avhaliullin
 */
public class ApiHistoryPoint<T> {
    private final DateTime date;
    private final T value;

    public ApiHistoryPoint(DateTime date, T value) {
        this.date = date;
        this.value = value;
    }

    @Description("Дата")
    public DateTime getDate() {
        return date;
    }

    @Description("Значение индикатора")
    public T getValue() {
        return value;
    }

    public static <T> ApiHistoryPoint<T> fromEntry(Map.Entry<DateTime, T> entry) {
        return new ApiHistoryPoint<>(entry.getKey(), entry.getValue());
    }

    public static ApiHistoryPoint<Long> fromDatePoint(DatePoint point) {
        return new ApiHistoryPoint<>(point.getTime().toDateTimeAtStartOfDay(TimeUtils.EUROPE_MOSCOW_ZONE), point.getValue());
    }
}
