package ru.yandex.webmaster3.api.http.common.request.converters;

import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.api.http.rest.types.WebmasterApiTypes;
import ru.yandex.webmaster3.core.http.ParameterConverter;
import ru.yandex.webmaster3.core.searchquery.QueryId;

import java.lang.reflect.Type;
import java.util.Optional;

/**
 * @author avhaliullin
 */
public class ApiQueryIdConverter implements ParameterConverter {
    @Override
    public ValueType describeType(Type type) {
        if (type == QueryId.class) {
            return WebmasterApiTypes.QUERY_ID;
        }

        return null;
    }

    @Override
    public Object convert(String value, Type toType) {
        if (toType == QueryId.class) {
            Optional<QueryId> resOpt = QueryId.fromStringId(value);
            if (resOpt.isPresent()) {
                return resOpt.get();
            } else {
                throw new IllegalArgumentException("Illegal query id " + value);
            }
        }

        return null;
    }
}
