package ru.yandex.webmaster3.api.http.common.request.converters;

import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.api.http.rest.types.WebmasterApiTypes;
import ru.yandex.webmaster3.api.sitemap.data.ApiSitemapId;
import ru.yandex.webmaster3.api.sitemap.util.SitemapIdUtil;
import ru.yandex.webmaster3.core.http.ParameterConverter;

import java.lang.reflect.Type;

/**
 * @author avhaliullin
 */
public class ApiSitemapIdConverter implements ParameterConverter {
    @Override
    public ValueType describeType(Type type) {
        if (type == ApiSitemapId.class) {
            return WebmasterApiTypes.SITEMAP_ID;
        }
        return null;
    }

    @Override
    public Object convert(String value, Type toType) {
        if (toType == ApiSitemapId.class) {
            ApiSitemapId result = SitemapIdUtil.fromString(value);
            if (result == null) {
                throw new IllegalArgumentException("Illegal sitemap id " + value);
            }
            return result;
        }
        return null;
    }
}
