package ru.yandex.webmaster3.api.http.common.request.converters;

import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.api.http.rest.types.WebmasterApiTypes;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ParameterConverter;
import ru.yandex.webmaster3.core.util.IdUtils;

import java.lang.reflect.Type;

/**
 * @author aherman
 */
public class ApiWebmasterHostIdConverter implements ParameterConverter {
    @Override
    public Object convert(String value, Type toType) {
        return convert(value);
    }

    @Override
    public ValueType describeType(Type type) {
        return WebmasterApiTypes.HOST_ID;
    }

    public static WebmasterHostId convert(String hostIdString) {
        try {
            return IdUtils.webIdStringToHostId(hostIdString, true);
        } catch (Exception e) {
            throw new IllegalArgumentException("Invalid host id string");
        }
    }
}
