package ru.yandex.webmaster3.api.http.common.request.parameters;

import ru.yandex.webmaster3.api.http.common.request.annotations.MaxValue;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestParameterFilter;
import ru.yandex.webmaster3.api.http.rest.request.MatchWithAnnotation;
import ru.yandex.webmaster3.core.http.internal.ParameterInfo;

import java.util.Optional;

/**
 * @author avhaliullin
 */
@MatchWithAnnotation(annotationClass = MaxValue.class)
public class MaxValueFilter implements ApiRequestParameterFilter<Number> {
    @Override
    public Optional<String> applyFilter(ParameterInfo parameter, Number value) {
        double maxValue = maxValue(parameter);
        if (value.doubleValue() > maxValue) {
            return Optional.of("max value is " + ParamFilterUtil.formatDouble(maxValue));
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> describe(ParameterInfo parameter) {
        return Optional.of("Max value: " + ParamFilterUtil.formatDouble(maxValue(parameter)));
    }

    private double maxValue(ParameterInfo parameterInfo) {
        return parameterInfo.getAnnotations(MaxValue.class)
                .stream()
                .map(MaxValue::value)
                .max(Double::compareTo)
                .get();
    }
}
