package ru.yandex.webmaster3.api.http.common.request.parameters;

import ru.yandex.webmaster3.api.http.common.request.annotations.MinValue;
import ru.yandex.webmaster3.api.http.rest.request.ApiRequestParameterFilter;
import ru.yandex.webmaster3.api.http.rest.request.MatchWithAnnotation;
import ru.yandex.webmaster3.core.http.internal.ParameterInfo;

import java.util.Optional;

/**
 * @author avhaliullin
 */
@MatchWithAnnotation(annotationClass = MinValue.class)
public class MinValueFilter implements ApiRequestParameterFilter<Number> {
    @Override
    public Optional<String> applyFilter(ParameterInfo parameter, Number value) {
        double minValue = minValue(parameter);
        if (value.doubleValue() < minValue) {
            return Optional.of("min value is " + ParamFilterUtil.formatDouble(minValue));
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> describe(ParameterInfo parameter) {
        return Optional.of("Min value: " + ParamFilterUtil.formatDouble(minValue(parameter)));
    }

    private double minValue(ParameterInfo parameterInfo) {
        return parameterInfo.getAnnotations(MinValue.class)
                .stream()
                .map(MinValue::value)
                .max(Double::compareTo)
                .get();
    }
}
