package ru.yandex.webmaster3.api.http.common.request.traits;

import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;

/**
 * @author avhaliullin
 */
public interface ApiDateRangeRequest {
    @RequestQueryProperty
    @Description("Начало диапазона дат для отображения")
    void setDateFrom(DateTime dateFrom);

    DateTime getDateFrom();

    @RequestQueryProperty
    @Description("Конец диапазона дат для отображения")
    void setDateTo(DateTime dateTo);

    DateTime getDateTo();

    @NotNull
    default DateTime getDateToOrNow() {
        var date = getDateTo();
        return date == null? DateTime.now() : date;
    }

    @NotNull
    default DateTime getDateFromOrNow() {
        var date = getDateFrom();
        return date == null? DateTime.now() : date;
    }
}
